<?php
if (! defined('ABSPATH')) {
    exit;
}

global $wp;

?>
<style>
	.woocommerce-checkout #payment div.payment_box.payment_method_payrex {
		padding-left: 0;
    padding-right: 0;

	}

  #payrex-payment-element {
		padding: 1em;
	}
</style>

<script type="text/javascript">
  document.addEventListener('DOMContentLoaded', async function () {

  elements = window.payrex.elements({
    clientSecret: "<?php echo esc_js($client_secret); ?>"
  });

  const paymentElement = elements.create("payment", {
    fields: {
      billingDetails: {
        email: "never",
        name: "never",
        phone: "never",
        address: {
          line1: "never",
          line2: "never",
          city: "never",
          postalCode: "never",
          state: "never",
          country: "never",
        },
      },
    },
  });

  paymentElement.mount("#payrex-payment-element");

  window.payrexElements = elements;
});

document.addEventListener('DOMContentLoaded', function () {
  const placeOrderButton = document.getElementById('place_order');

  if (placeOrderButton) {
    placeOrderButton.addEventListener('click', async function (event) {
    
      const payrexContainer = document.querySelector('.payment_box.payment_method_payrex');
              
      const existingError = payrexContainer.querySelector('.woocommerce-error');
      
      if (existingError) existingError.remove();

      let selectedPaymentMethod = document.querySelector('input[name="payment_method"]:checked');

      if (selectedPaymentMethod.value === 'payrex') {
        event.preventDefault();

        const attachResponse = await window.payrex.attachPaymentMethod({
          elements: window.payrexElements,
          options: {
            return_url: "<?php echo esc_url($redirect_url); ?>",
          },
          attachParams: {
            paymentMethodData: {
              billingDetails: {
                name: `${window.wcSettings.checkoutData.billing_address.first_name} ${window.wcSettings.checkoutData.billing_address.last_name}`,
                email: window.wcSettings.checkoutData.billing_address.email,
                address: {
                  line1: window.wcSettings.checkoutData.billing_address.address_1,
                  city: window.wcSettings.checkoutData.billing_address.city,
                  state: window.wcSettings.checkoutData.billing_address.state,
                  postalCode: window.wcSettings.checkoutData.billing_address.postal_code,
                  country: window.wcSettings.checkoutData.billing_address.country
                },
                ...(window.wcSettings.checkoutData.billing_address.phone === ''
                  ? {}
                  : { phone: window.wcSettings.checkoutData.billing_address.phone })
              }
            }
          }
        });

        const successfulStatus = ['awaiting_capture', 'succeeded']

        const failedStatus = [
          'awaiting_action',
          'awaiting_payment_method',
          'canceled'
        ]

        let errorMessage = ''

        if (typeof attachResponse === 'string') {
          errorMessage = attachResponse
        } else if (!attachResponse) {
          errorMessage = 'The latest payment authentication has failed or cancelled.'
        } else if (failedStatus.includes(attachResponse.status)) {
          errorMessage =
            attachResponse.last_payment_error?.detail ||
            'The latest payment authentication has failed or cancelled.'
        } else {
          errorMessage = 'The latest payment authentication has failed or cancelled.'
        }

        if (errorMessage !== '') {
          const errorBox = document.createElement('ul');
          errorBox.className = 'woocommerce-error';
          errorBox.innerHTML = '<li>' + errorMessage + '</li>';

          payrexContainer.insertBefore(errorBox, payrexContainer.firstChild);
        }
      }
    });
  }
});
</script>
