<?php

class WC_Token
{
    public const TOKEN_EXPIRATION_SECONDS = 60;

    public static function generate_create_payment_intent_token()
    {
        $token = bin2hex(random_bytes(32));
        $expires = time() + self::TOKEN_EXPIRATION_SECONDS;

        set_transient("create_payment_intent_token_$token", [
            'purpose' => 'create-payment-intent',
            'expires' => $expires,
        ], self::TOKEN_EXPIRATION_SECONDS);

        return $token;
    }

    public static function validate_create_payment_intent_token($token)
    {
        $data = get_transient("create_payment_intent_token_$token");

        if (!$data || $data['purpose'] !== 'create-payment-intent' || time() > $data['expires']) {
            return false;
        } else {
            delete_transient("create_payment_intent_token_$token");

            return true;
        }
    }
}
